define(['modules/new-appointment-request/resources/common/city-state/collection'], function(Collection) {
    'use strict';


    describe('City State Collection', function() {
        it('has the correct resource name', function() {
            var collection = new Collection();
            expect(collection.resourceName).toBe('city-state');
        });

        it('generates the correct url', function() {
            var collection = new Collection();
            expect(collection.url()).toBe('base-url/VeteranAppointmentRequestService/v4/rest/direct-scheduling/parent-sites');
        });

        it('finds the correct fetch data', function() {
            var collection = new Collection();
            expect(collection._getFetchData()).toEqual({'facility-code': ['100', '200']});
        });

        describe('Grouping and Sorting', function() {
            var collection;

            beforeEach(function() {
                collection = new Collection([
                    {
                        'institutionCode': '636A6',
                        'city': 'Des Moines',
                        'stateAbbrev': 'IA',
                        'authoritativeName': 'Des Moines VA Medical Center',
                        'rootStationCode': '636',
                        'adminParent': true,
                        'parentStationCode': '636A6',
                    }, {
                        'institutionCode': '636',
                        'city': 'Omaha',
                        'stateAbbrev': 'NE',
                        'authoritativeName': 'Omaha VA Medical Center',
                        'rootStationCode': '636',
                        'adminParent': true,
                        'parentStationCode': '636',
                    }, {
                        'institutionCode': '523',
                        'city': 'BOSTON',
                        'stateAbbrev': 'MA',
                        'authoritativeName': 'BOSTON HCS VAMC',
                        'rootStationCode': '523',
                        'adminParent': true,
                        'parentStationCode': '523',
                    }, {
                        'institutionCode': '636A8',
                        'city': 'Iowa City',
                        'stateAbbrev': 'IA',
                        'authoritativeName': 'Iowa City VA Medical Center',
                        'rootStationCode': '636',
                        'adminParent': true,
                        'parentStationCode': '636A8',
                    },
                ], {parse: true});
            });

            it('sorts the collection', function() {
                expect(collection.at(0).get('city')).toBe('Des Moines');
                expect(collection.at(1).get('city')).toBe('Iowa City');
                expect(collection.at(2).get('city')).toBe('BOSTON');
                expect(collection.at(3).get('city')).toBe('Omaha');
            });

            it('groups the collection', function() {
                var group = collection.group();

                expect(group.Iowa[0].text).toBe('Des Moines, IA');
                expect(group.Iowa[1].text).toBe('Iowa City, IA');
                expect(group.Massachusetts[0].text).toBe('BOSTON, MA');
                expect(group.Nebraska[0].text).toBe('Omaha, NE');

                expect(group.Iowa[0].value).toBe('636A6');
                expect(group.Iowa[1].value).toBe('636A8');
                expect(group.Massachusetts[0].value).toBe('523');
                expect(group.Nebraska[0].value).toBe('636');
            });
        });
    });
});
